/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import tech.vvp.vvp.radar.IRadarVehicle;

public class RadarHud {
    public static boolean hudEnabled = true;
    public static Position position = Position.TOP_LEFT;
    public static List<Vec3> radarTargets = new ArrayList<Vec3>();
    private static final ResourceLocation RADAR_BACKGROUND = new ResourceLocation("vvp", "textures/gui/radar_bg.png");
    private static final ResourceLocation RADAR_TARGET = new ResourceLocation("vvp", "textures/gui/radar_target.png");
    private static final int RADAR_SIZE = 96;
    private static final int MARGIN = 10;
    private static final long HOLD_TIME_MS = 500L;
    private static final long FADE_TIME_MS = 800L;
    private static final float MIN_ALPHA = 0.06f;
    private static final long BLINK_OFF_MS = 1500L;
    private static final long BLINK_ON_MS = 2500L;
    private static final long BLINK_TOTAL = 4000L;
    private static final long BLINK_FADE_MS = 350L;
    private static final Map<Long, Long> lastSeen = new HashMap<Long, Long>();
    private static final Map<Long, Vec3> lastPos = new HashMap<Long, Vec3>();
    public static final IGuiOverlay HUD_RADAR = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        int radarX;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_() || mc.f_91073_ == null) {
            return;
        }
        Entity vehicle = player.m_20202_();
        if (!(vehicle instanceof IRadarVehicle)) {
            return;
        }
        IRadarVehicle rv = (IRadarVehicle)vehicle;
        if (!hudEnabled) {
            return;
        }
        int radarY = switch (position) {
            case Position.TOP_RIGHT -> {
                radarX = screenWidth - 96 - 10;
                yield 10;
            }
            case Position.MID_RIGHT -> {
                radarX = screenWidth - 96 - 10;
                yield (screenHeight - 96) / 2;
            }
            case Position.BOTTOM_RIGHT -> {
                radarX = screenWidth - 96 - 10;
                yield screenHeight - 96 - 10;
            }
            case Position.BOTTOM_LEFT -> {
                radarX = 10;
                yield screenHeight - 96 - 10;
            }
            case Position.MID_LEFT -> {
                radarX = 10;
                yield (screenHeight - 96) / 2;
            }
            default -> {
                radarX = 10;
                yield 10;
            }
        };
        int radarCenterX = radarX + 48;
        int radarCenterY = radarY + 48;
        int radarRange = Math.max(rv.getRadarRange(), 1);
        float radarDisplayRange = (float)radarRange * 2.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(RADAR_BACKGROUND, radarX, radarY, 0.0f, 0.0f, 96, 96, 96, 96);
        long now = System.currentTimeMillis();
        lastSeen.entrySet().removeIf(e -> now - (Long)e.getValue() > 1300L);
        lastPos.keySet().retainAll(lastSeen.keySet());
        float blink = RadarHud.computeBlinkAlpha(now);
        if (blink <= 0.01f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            return;
        }
        Vec3 origin = vehicle.m_20182_();
        double yawRad = Math.toRadians(vehicle.m_146908_());
        for (Map.Entry<Long, Vec3> entry : lastPos.entrySet()) {
            float alpha;
            Vec3 pos = entry.getValue();
            long seen = lastSeen.getOrDefault(entry.getKey(), now);
            long dt = now - seen;
            if (dt <= 500L) {
                alpha = 1.0f;
            } else {
                float k = Math.min(1.0f, (float)(dt - 500L) / 800.0f);
                alpha = 1.0f - 0.94f * k;
            }
            Vec3 rel = pos.m_82546_(origin);
            double dx = rel.f_82479_;
            double dz = rel.f_82481_;
            double distance = Math.sqrt(dx * dx + dz * dz);
            if (distance < 1.0E-6 || distance > (double)radarRange) continue;
            double localX = -(dx * Math.cos(yawRad) + dz * Math.sin(yawRad));
            double localZ = -dx * Math.sin(yawRad) + dz * Math.cos(yawRad);
            double displayDist = Math.min(distance / (double)radarDisplayRange * 44.0, 44.0);
            double nx = localX / distance;
            double nz = localZ / distance;
            int targetX = radarCenterX + (int)(nx * displayDist);
            int targetY = radarCenterY - (int)(nz * displayDist);
            float finalAlpha = alpha * blink;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)finalAlpha);
            int s = 3;
            guiGraphics.m_280163_(RADAR_TARGET, targetX - s / 2, targetY - s / 2, 0.0f, 0.0f, s, s, s, s);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    };

    public static void onServerTargetsUpdate(List<Vec3> targetsFromServer) {
        radarTargets = targetsFromServer;
        long now = System.currentTimeMillis();
        for (Vec3 pos : targetsFromServer) {
            long key = RadarHud.cellKey(pos);
            lastSeen.put(key, now);
            lastPos.put(key, pos);
        }
    }

    public static Position cyclePosition() {
        switch (position) {
            case TOP_LEFT: {
                position = Position.TOP_RIGHT;
                break;
            }
            case TOP_RIGHT: {
                position = Position.MID_RIGHT;
                break;
            }
            case MID_RIGHT: {
                position = Position.BOTTOM_RIGHT;
                break;
            }
            case BOTTOM_RIGHT: {
                position = Position.BOTTOM_LEFT;
                break;
            }
            case BOTTOM_LEFT: {
                position = Position.MID_LEFT;
                break;
            }
            case MID_LEFT: {
                position = Position.TOP_LEFT;
            }
        }
        return position;
    }

    public static String positionId(Position p) {
        return switch (p) {
            default -> throw new IncompatibleClassChangeError();
            case Position.TOP_LEFT -> "top_left";
            case Position.TOP_RIGHT -> "top_right";
            case Position.MID_RIGHT -> "mid_right";
            case Position.BOTTOM_RIGHT -> "bottom_right";
            case Position.BOTTOM_LEFT -> "bottom_left";
            case Position.MID_LEFT -> "mid_left";
        };
    }

    private static float normalize360(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static long cellKey(Vec3 pos) {
        int cx = Mth.m_14107_((double)(pos.f_82479_ * 2.0));
        int cz = Mth.m_14107_((double)(pos.f_82481_ * 2.0));
        return (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
    }

    private static float computeBlinkAlpha(long nowMs) {
        long phase = nowMs % 4000L;
        long offHard = Math.max(0, 1150);
        if (phase < offHard) {
            return 0.0f;
        }
        if (phase < 1500L) {
            float x = (float)(phase - offHard) / 350.0f;
            return RadarHud.smooth01(x);
        }
        long onPhase = phase - 1500L;
        long onHard = Math.max(0, 2150);
        if (onPhase < onHard) {
            return 1.0f;
        }
        if (onPhase < 2500L) {
            float x = 1.0f - (float)(onPhase - onHard) / 350.0f;
            return RadarHud.smooth01(x);
        }
        return 0.0f;
    }

    private static float smooth01(float x) {
        x = Mth.m_14036_((float)x, (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        MID_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT,
        MID_LEFT;

    }
}

